#include <bits/stdc++.h>

#define ll long long

struct Point
{
    ll x, h;
    ll index;
};

int main()
{
    ll n, it = 0;
    std::cin >> n;

    std::vector<Point> p(n);
    std::vector<ll> res(n, -1);

    for(ll i = 0; i < n; i++)
        std::cin >> p[i].x;
    for(ll i = 0; i < n; i++)
        std::cin >> p[i].h;

    for(ll i = 0; i < n; i++)
        p[i].index = i;

    std::sort(p.begin(), p.end(), [](const Point& a, const Point& b) {
        return a.x < b.x;
    });

    std::vector<ll> minl(n, 1e18), minr(n, 1e18);

    for(ll i = 0; i < n - 1; i++)
    {
        for(ll j = i + 1; j < n; j++)
        {
            Point& p1 = p[i];
            Point& p2 = p[j];

            if(p2.h >= p1.h)
            {
                minl[p1.index] = (p2.x - p1.x) - (p2.h - p1.h);
                break;
            }
        }
    }

    for(ll i = n - 1; i > 0; i--)
    {
        for(ll j = i - 1; j >= 0; j--)
        {
            Point& p1 = p[i];
            Point& p2 = p[j];

            if(p2.h >= p1.h)
            {
                minr[p1.index] = (p1.x - p2.x) - (p2.h - p1.h);
                break;
            }
        }
    }

    for(ll i = 0; i < n; i++)
    {
        res[i] = std::min(minl[i], minr[i]);
        if(res[i] == 1e18)
            res[i] = -1;
    }

    for(ll i = 0; i < n; i++)
        std::cout << res[i] << "\n";
    
    return 0;
}